#pragma once

class CConfigWriter  
{
public:
	CConfigWriter(const tstring& aFileName);
	virtual ~CConfigWriter();

	void close();
	/**
	 * We can cancel file creation when we don't close it yet.
	 * Temporary file will be removed.
	 * If file was already created (closed) this method does nothing.
	 */
	void cancel();

	class CEntityResolver {
	public:
		CEntityResolver() {}
	};

	class COemManipulator {
	public:
		COemManipulator() {}
	};

	CConfigWriter& operator <<(const tstring& data);
	CConfigWriter& operator <<(LPCTSTR data);
	CConfigWriter& operator <<(const int data);
	CConfigWriter& operator <<(const CEntityResolver& resolver);
	CConfigWriter& operator <<(const COemManipulator& oem);

protected:
	tstring		fileName;
	tstring		tempFileName;
	ofstream	out;
	bool		closed;
	bool		resolveEntities;
	tstring		resolvedData;
	bool		oemData;

	void print(LPCTSTR data);
	void resolve(LPCTSTR data);
};
